#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timer 4 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/*******************************************************************
*    Function Name: ConfigIntTimer4                                *
*    Description:   This Function Configures Interrupt and sets    *
*                   Interrupt Priority                             *
*    Parameters:    unsigned int config                            *
*    Return Value:  None                                           *
*******************************************************************/

void ConfigIntTimer4(unsigned int config)
{
    IFS1bits.T4IF = 0;                   /* clear IF bit */
    IPC5bits.T4IP = (config &0x0007);    /* assigning Interrupt Priority */
    IEC1bits.T4IE = (config &0x0008)>>3; /* Interrupt Enable /Disable */
}

#endif 
